/*{
    "DESCRIPTION": "Mixer",
    "CREDIT": "",
    "ISFVSN": "2",
    "CATEGORIES": [
        "Composition"
    ],
    "INPUTS": [
        {
            "NAME": "inputImage",
            "TYPE": "image"
        },
        {
            "NAME": "topImage",
            "TYPE": "image"
        },
        {
            "NAME": "dryWet",
            "TYPE": "float",
            "DEFAULT": 1.0,
            "MIN": 0.0,
            "MAX": 1.0
        }
    ]
    
}*/

void main() {
    
    float dryWet2 = min(1.0, 2.0 * dryWet);
    float lastPart = max(0.0, (dryWet - 0.5) * 2.0);
    vec4 bottom = IMG_NORM_PIXEL(inputImage, isf_FragNormCoord) * 1.0 - lastPart;
    vec4 top = IMG_NORM_PIXEL(topImage, isf_FragNormCoord) * dryWet2;
    float luma = (top.r + top.g + top.b) / 3.0;

    gl_FragColor = luma > 0.4 ? mix(bottom, top, dryWet2) : mix(bottom, top, min(1.0, (lastPart + luma / 0.4)) * dryWet2);
}

